--***********************************************************
--**                    ShadowCop		                   **
--***********************************************************

function chainsaw_swing(player, chainsaw)	

	if chainsaw:getType() == "Chainsaw" then	
		local ModData = chainsaw:getModData();
		if ModData.Run == true then
			chainsaw_fuel(player, chainsaw, 1, 0);		
		end
	end		
end

function chainsaw_status()
    local player = getPlayer();		
	if player == nil then return end;
    if player:isDead() then return end;
	local container = player:getInventory();
	for j=1,container:getItems():size() do
		local item = container:getItems():get(j-1)
		if item:getType() == "Chainsaw" then
			local ModData = item:getModData();
		-- Status initialization
			if ModData.IdleTime == nil then
				ModData.IdleTime = 0;
			end
			if ModData.FuelAmt == nil then
				ModData.FuelAmt = 0;
			end
			if ModData.Run == nil then
				ModData.Run = false;
			end
		-- Status fuel
			if player:isEquipped(item) then 
				if ModData.Run == true then
					chainsaw_fuel(player, item, 0, 0.5)
				end
			else
				ModData.Run = false;
			end	
		-- Status modification
			if ModData.Run == false then 
				item:setConditionLowerChance(20);
				item:setCriticalChance(10);
				item:setDoSwingBeforeImpact(0.12);
				item:setKnockdownMod(1);
				item:setMinDamage(1);
				item:setMaxDamage(2);
				item:setMaxHitCount(1);	
				item:setPushBackMod(0.3);
				item:setDoorDamage(10);
				item:setTreeDamage(10);
			end
			if ModData.Run == true then
				item:setConditionLowerChance(60);
				item:setCriticalChance(40);
				item:setDoSwingBeforeImpact(0.02);
				item:setKnockdownMod(2);
				item:setMinDamage(4);
				item:setMaxDamage(7);
				item:setMaxHitCount(6);	
				item:setPushBackMod(0.1);
				item:setDoorDamage(100);
				item:setTreeDamage(150);
			end
		end
	end

end

function chainsaw_fuel(player, chainsaw, hit, idle)

	local ModData = chainsaw:getModData();
	if hit ~= 0 then
		-- Chainsaw hit
		if ModData.FuelAmt > 0 then
			player:playSound("cs_hit");
			addSound(player, player:getX(), player:getY(), player:getZ(), 20, 1);
			ModData.FuelAmt = ModData.FuelAmt - hit;
			ModData.IdleTime = 0;
		end						
	elseif ModData.IdleTime > 120 then
		-- Chainsaw idle
		if ModData.FuelAmt > 0 then
			player:playSound("cs_idle");
			addSound(player, player:getX(), player:getY(), player:getZ(), 5, 1);
			ModData.FuelAmt = ModData.FuelAmt - idle;
			ModData.IdleTime = 0;
		end					
	end	
	
	--Add Idle Time
	ModData.IdleTime = ModData.IdleTime + getGameTime():getMultiplier();		

	--Stop Chainsaw when running out of fuel
	if ModData.FuelAmt <= 0 then
		ModData.FuelAmt = 0;
		ModData.IdleTime = 0;
		ModData.Run = false;
	end
end

function chainsaw_add(player, square)
--	just for testing
	player:getInventory():AddItem("ChainsawRevolution.Chainsaw");
	player:getInventory():AddItem("Base.PetrolCan");
	player:getInventory():AddItem("RealReceiptsPack.FellingAxe");
	player:getInventory():AddItem("RealReceiptsPack.AxeHead");
	player:getInventory():AddItem("RealReceiptsPack.AxeHandle");
end

Events.OnWeaponSwing.Add(chainsaw_swing);
Events.OnNewGame.Add(chainsaw_add);
Events.OnTick.Add(chainsaw_status);